// IncludThread.java
// 13 feb Jonas

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import Globals;

public class IncludThread extends Thread {
  public Letter2 L;
  private int startX, startY, endX, endY, x ,y;
  Graphics g;
  ShowMobileIPCanvas canvas;
  
  public void start(int x, int y, int endX, int endY,
		    ShowMobileIPCanvas father) {
    this.canvas = father; 
    this.startX = x; this.startY = y; 
    this.endX = endX; this.endY = endY; 
    this.x = x; this.y = y;
    L = new Letter2(canvas);
    g = canvas.getGraphics();
    super.start(); // run() MUST be started from Thread.start()
  }
 public void run() {
    // Print first message
    Globals.actionAllowed = false; // MH interaction disabled
    canvas.frame.textArea1.appendHiLit(canvas.inclText1 
                              + canvas.inclText2 );
    L.drawLetter(g, Globals.MH.connected.x, Globals.MH.connected.y); 
    canvas.frame.setCont();
    // Define letter informationText
    L.info =  "Contains a request from  " 
              +Globals.MH.connected.name+ " to register MH.";
    run1(endX, endY);
    Globals.FA[0].believeMH = Globals.MH.connected;
    if (Globals.dialogExist[0])
      Globals.Dialogs[0].reDraw2(); // Redraws Dialog
    canvas.frame.textArea1.appendHiLit(canvas.inclText3 + canvas.inclText4);
  
    pause(Globals.pauseTime); // Pause before next animation
  
    
    L.info =  "Contains an acknowledgement from HA that " 
              +Globals.MH.connected.name+ " is allowed to register MH.";
    run1(startX, startY);
    L.eraseLetter(g);
    canvas.frame.setDisabled(); // Disables buttons
    int i = 0;
    while (Globals.MH.connected != Globals.FA[i])
      i++;
    Globals.FA[i].believeMH = Globals.MH.connected;
    if (Globals.dialogExist[i])
      Globals.Dialogs[i].reDraw2(); // Redraws Dialog
    canvas.frame.textArea1.appendHiLit(canvas.inclText5);
    Globals.actionAllowed = true; // MH interaction allowed
  } // end run()

  // Animation of Letter
  private void run1(int toX, int toY) {
    int biggest = Math.max(Math.abs(toY - y), Math.abs(toX - x));
    float dx = (float) (toX - x) / biggest;
    float dy = (float) (toY - y) / biggest;
    float xtemp = (float) x;
    float ytemp = (float) y; 
    float minToY = toY - Math.abs(dy), maxToY = toY + Math.abs(dy);
    float minToX = toX - Math.abs(dx), maxToX = toX + Math.abs(dx);
  
  
    // while ((x != toX) && (y != toY)) { 
    while (!(((ytemp < maxToY) && (ytemp > minToY)) && 
	     ((xtemp < maxToX) && (xtemp > minToX)))) {
      if (Globals.contAllowed) { // Check whether user pressed Stop 
     	xtemp  = xtemp+dx;
	ytemp  = ytemp+dy;
	g.setColor(Color.lightGray);
	g.fillRect(x-1, y-1, 22, 14);
	x = (int) xtemp;
	y = (int) ytemp;
	canvas.paint(g); 
	L.drawLetter(g, x, y); 
	 try {  
	  sleep(Globals.sleepTime);
	 } catch (InterruptedException e) {break;}
      }
      else { // Wait for user to press continue
	canvas.frame.setStop(); // Activate Stopbutton
	this.suspend();
      }
    } // end while   
  }
    
  public void pause(int time) {
    try {  
      Thread.sleep(time);
    } catch (InterruptedException e) {System.out.println("DeRegThread-pause");}
  }
}
